//
//  $Id: WXKMailWindowController.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKMailWindowController.h"
#import "FJNCoreDataArrayController.h"
#import "WXKMail.h"
#import "WXKMailValueTransformer.h"


//NSString *kWXKMailPhoneNumberDefaultsKey  = @"WXKMailPhoneNumberDefaultsKey";
NSString *kWXKMailExportFormatDefaultsKey = @"WXKMailExportFormatDefaultsKey";
NSString *WXKMailToolbarViewSourceIdentifier          = @"View Source Item Identifier";
NSString *WXKMailToolbarExportSelectionItemIdentifier = @"Export Selection Item Identifier";

typedef enum
{
	WXKMailWindowControllerMboxFileFormat = 0,
	WXKMailWindowControllerRFC822MessageFileFormat,
	WXKMailWindowControllerVMessageFileFormat
} WXKMailWindowControllerFileFormat;


@implementation WXKMailWindowController


+ (void)initialize
{
	[NSDateFormatter setDefaultFormatterBehavior:NSDateFormatterBehavior10_4];
	
    NSUserDefaults	*userDefaults			= [NSUserDefaults standardUserDefaults];
    NSDictionary	*regstrationDictionary	= [NSDictionary dictionaryWithObjectsAndKeys:
											   // @"07000000000", kWXKMailPhoneNumberDefaultsKey, 
											   [NSNumber numberWithInt:0], kWXKMailExportFormatDefaultsKey,
											   nil];
    [userDefaults registerDefaults:regstrationDictionary];
	
	WXKMailValueTransformer *transformer = [[[WXKMailValueTransformer alloc] init] autorelease];
	[NSValueTransformer setValueTransformer:transformer forName:@"WXKLockIconFromIsSecured"];
}

#pragma mark Initialization and deallocation

- (id)init
{
	self = [super initWithWindowNibName:@"MailWindow" storeDirectory:@"Kyopon Utilities" filename:@"mails.wxkbinary" type:NSBinaryStoreType];
	return self;
}

- (void)windowWillLoad
{
	[super windowWillLoad];
	
	[self setWindowFrameAutosaveName:@"MailWindowFrame"];
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(mailboxesTableViewSelectionDidChange:)
												 name:NSTableViewSelectionDidChangeNotification
											   object:[[self containerArrayController] tableView]];
	
	NSMutableArray *dictionaries = [NSMutableArray arrayWithCapacity:20];
	NSDictionary *keyedValues;
	int i;
	for (i = 0; i < 3; i++)
	{
		NSString *title = nil;
		switch (i + 1)
		{
			case 1:
				title = NSLocalizedStringFromTable(@"Sent", @"MailLocalizable", @"mailbox.sent");
				break;
			case 2:
				title = NSLocalizedStringFromTable(@"Drafts", @"MailLocalizable", @"mailbox.draft");
				break;
			case 3:
				title = NSLocalizedStringFromTable(@"Inbox", @"MailLocalizable", @"mailbox.inbox");
				break;
		}
		keyedValues = [NSDictionary dictionaryWithObjectsAndKeys:
					   [NSNumber numberWithLong:i + 1], @"order",
					   title, @"title",
					   nil];
		[dictionaries addObject:keyedValues];
	}
	[[self containerArrayController] initializedObjectsWithDictionaries:dictionaries];
	
	[[self contentArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"mail", @"MailLocalizable", @"childEntityName")];
	[[self containerArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"mail box", @"MailLocalizable", @"parentEntityName")];
	[[self contentArrayController] setEntityImageName:@"ToolbarMailIcon.tiff"];
	
	[[self contentArrayController] setSupportsDragAndDrop:NO];
	
	[self setupToolbarWithIdentifier:@"KyoponMailsToolbarIdentifier"];
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:NSTableViewSelectionDidChangeNotification
												  object:[[self containerArrayController] tableView]];
	
	[super dealloc];
}

#pragma mark NSNotification observer

- (void)mailboxesTableViewSelectionDidChange:(NSNotification *)aNotification
{
	NSArray *selectedMailBox = [[self containerArrayController] selectedObjects];
	
	NSEnumerator *enumerator = [selectedMailBox objectEnumerator];
	NSManagedObject *mailBox;
	
	BOOL isInboxSelected = NO;
	BOOL isOutboxSelected = NO;
	while (mailBox = [enumerator nextObject])
	{
		switch ([[mailBox valueForKey:@"order"] intValue])
		{
			case WXKMailInboxMailBox:
				isInboxSelected = YES; break;
			case WXKMailDraftMailBox:
			case WXKMailSentMailBox:
				isOutboxSelected = YES; break;
		}
	}
	
	id cell = [[[[self contentArrayController] tableView] tableColumnWithIdentifier:@"object"] headerCell];
	if (isInboxSelected && isOutboxSelected)
	{
		[cell setStringValue:NSLocalizedStringFromTable(@"From/To", @"MailLocalizable", @"objectHeaderCell.fromAndTo")];
	}
	else if (isInboxSelected)
	{
		[cell setStringValue:NSLocalizedStringFromTable(@"From", @"MailLocalizable", @"objectHeaderCell.from")];
	}
	else if (isOutboxSelected)
	{
		[cell setStringValue:NSLocalizedStringFromTable(@"To", @"MailLocalizable", @"objectHeaderCell.to")];
	}
}

#pragma mark Action methods

- (IBAction)exportSelection:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setCanChooseDirectories:YES];
	[openPanel setCanChooseFiles:NO];
	[openPanel setCanCreateDirectories:YES];
	[openPanel setAccessoryView:exportFormatView];
	[openPanel setTitle:NSLocalizedStringFromTable(@"Export", @"MailLocalizable", @"exportAlert.title")];
	[openPanel setPrompt:NSLocalizedStringFromTable(@"Export", @"MailLocalizable", @"exportAlert.prompt")];
	
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	[exportFormatPopUpButton selectItemAtIndex:[userDefaults integerForKey:kWXKMailExportFormatDefaultsKey]];
	
	[openPanel beginSheetForDirectory:nil
								 file:nil
								types:nil
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(exportSelectionOpenPanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)exportSelectionOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton)
	{
		WXKMailWindowControllerFileFormat format = [exportFormatPopUpButton indexOfSelectedItem];
		
		NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
		// [userDefaults setObject:phoneNumber forKey:kWXKMailPhoneNumberDefaultsKey];
		[userDefaults setInteger:format forKey:kWXKMailExportFormatDefaultsKey];
		
		NSString *directoryPath = [openPanel filename];
		NSArray *mails = [[self contentArrayController] selectedObjects];
		
		switch (format)
		{
			case WXKMailWindowControllerMboxFileFormat:
				[self writeMboxOfMails:mails toDirectory:directoryPath]; break;
			case WXKMailWindowControllerRFC822MessageFileFormat:
				[self writeMailsAsRFC822Message:mails toDirectory:directoryPath]; break;
			case WXKMailWindowControllerVMessageFileFormat:
				[self writeVMessageOfMails:mails toDirectory:directoryPath]; break;
		}
	}
}

- (IBAction)viewSource:(id)sender
{
	[sourceWindow makeKeyAndOrderFront:sender];
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = nil;
	
	if ([itemIdentifier isEqual:WXKMailToolbarExportSelectionItemIdentifier])
	{
		// Export Selection
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Export", @"MailLocalizable", @"exportSelectionToolbarItem.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Export Selection", @"MailLocalizable", @"exportSelectionToolbarItem.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Export Selected Mails", @"MailLocalizable", @"exportSelectionToolbarItem.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarExportSelectionIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(exportSelection:)];
	}
	else if ([itemIdentifier isEqual:WXKMailToolbarViewSourceIdentifier])
	{
		// View Source
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Source", @"MailLocalizable", @"viewSourceToolbarItem.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"View Source", @"MailLocalizable", @"viewSourceToolbarItem.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"View Source", @"MailLocalizable", @"viewSourceToolbarItem.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarViewSourceIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(viewSource:)];
	}
	else
	{
		toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
	}
	
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			// FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarDeleteContentIdentifier, 
			NSToolbarSeparatorItemIdentifier,
			WXKToolbarReceiveItemIdentifier, 
			// WXKToolbarSendItemIdentifier, 
			NSToolbarFlexibleSpaceItemIdentifier,
			FJNContainableToolbarSearchContentIdentifier, 
			nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			// FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarDeleteContentIdentifier,
			FJNContainableToolbarPreviousContentIdentifier,
			FJNContainableToolbarNextContentIdentifier,
			FJNContainableToolbarPreviousContainerIdentifier,
			FJNContainableToolbarNextContainerIdentifier,
			FJNContainableToolbarDeselectSortIdentifier,
			FJNContainableToolbarSearchContentIdentifier,
			// FJNIndexedItemsToolbarReindexSelectionIdentifier,
			WXKMailToolbarExportSelectionItemIdentifier, 
			WXKMailToolbarViewSourceIdentifier, 
			WXKToolbarReceiveItemIdentifier,
			// WXKToolbarSendItemIdentifier,
			WXKToolbarAddressUtilityItemIdentifier,
			WXKToolbarBookmarkUtilityItemIdentifier,
			WXKToolbarFileUtilityItemIdentifier,
			// WXKToolbarMailUtilityItemIdentifier,
			NSToolbarPrintItemIdentifier,
			// NSToolbarShowColorsItemIdentifier,
			// NSToolbarShowFontsItemIdentifier, 
			NSToolbarCustomizeToolbarItemIdentifier,
			NSToolbarSeparatorItemIdentifier, 
			NSToolbarSpaceItemIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier, 
			nil];
}

#pragma mark Methods implementing NSValidatedUserInterfaceItem protocol

- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)theItem
{
	if ([theItem action] == @selector(exportSelection:))
	{
		return [[[self contentArrayController] selectedObjects] count] > 0;
	}
	return [super validateUserInterfaceItem:theItem];
}

@end
